<?php

class Magen4me_BanwirePro_Helper_Data extends Mage_Core_Helper_Abstract
{

    /**
     * @author Ultiminio Ramos G. 2014-08-18
     * 
     * @param string $cadenaConAcentos
     * @return string
     */
    public function quitarAcentos($cadenaConAcentos)
    {
        return preg_replace("/[^\x01-\x7F]/", "", $cadenaConAcentos);
        //$this->convertAscii($cadenaConAcentos);

        $a_tofind = array('À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'à', 'á', 'â', 'ã', 'ä', 'å'
            , 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', 'Ø', 'ò', 'ó', 'ô', 'õ', 'ö', 'ø'
            , 'È', 'É', 'Ê', 'Ë', 'è', 'é', 'ê', 'ë', 'Ç', 'ç'
            , 'Ì', 'Í', 'Î', 'Ï', 'ì', 'í', 'î', 'ï'
            , 'Ù', 'Ú', 'Û', 'Ü', 'ù', 'ú', 'û', 'ü', 'ÿ', 'Ñ', 'ñ');
        $a_replac = array('A', 'A', 'A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a', 'a'
            , 'O', 'O', 'O', 'O', 'O', 'O', 'o', 'o', 'o', 'o', 'o', 'o'
            , 'E', 'E', 'E', 'E', 'e', 'e', 'e', 'e', 'C', 'c'
            , 'I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'
            , 'U', 'U', 'U', 'U', 'u', 'u', 'u', 'u', 'y', 'N', 'n');
        $cadenaSinAcentos = str_replace($a_tofind, $a_replac, $cadenaConAcentos);

        return $cadenaSinAcentos;
    }

    /**
     * @author Ultiminio Ramos G. 2014-08-18
     * 
     * @param string $cadenaTelefonoOrigen
     * @return string
     */
    public function normalizarTelefono($cadenaTelefonoOrigen)
    {
        $a_tofind = array('+', '(', ')', ' ', '=', '|', ',', '.', ':', '_', '-', ';'
            , '-', '*', '?', '¿', '¡', '!', '"', "'", '[', ']', '{', '}'
            , '^', '<', '>', '\\', '/', '$', '%', '&', '°'
        );
        $a_replac = array('', '', '', '', '', '', '', '', '', '', '', ''
            , '', '', '', '', '', '', '', '', '', '', '', ''
            , '', '', '', '', '', '', '', '', ''
        );

        $cadenaTelefono = $this->quitarAcentos($cadenaTelefonoOrigen);
        $cadenaTelefono2 = str_replace($a_tofind, $a_replac, $cadenaTelefono);

        return $cadenaTelefono2;
    }

    /**
     * Enmascarar el número de la tarjeta dejar visible los últimos 4 dígitos
     * 
     * @author Ultiminio Ramos G. 2014-08-18
     * @param string $numTarjeta El número de la tarjea a enmascarar
     * @return string El número de la tarjeta con asteriscos
     */
    public function enmascararTarjeta($numTarjeta)
    {
        $last4 = substr($numTarjeta, -4, 4);

        return '**** **** **** ' . $last4;
    }

    /**
     * Regresar la url del gateway de pago de Banwire
     * 
     * @author Ultiminio Ramos G. 2014-08-18
     * @param bool $prod Si debe regresar el entorno de producción o pruebas
     * @return string La url del gateway de Banwire
     */
    public function getBwUrl($prod = TRUE)
    {
        if (TRUE === $prod) {
            return 'https://banwire.com/qa/api/1/payment/direct';
        } else {
            return 'https://banwire.com/api/1/payment/direct';
        }
    }

    /**
     * Regresar la url del Snare Finger Print
     * 
     * @author Ultiminio Ramos G. 2014-08-18
     * @param bool $prod Si debe regresar el entorno de producción o pruebas
     * @return string La url del snare.js
     */
    public function getSnareUrl($prod = TRUE)
    {
        if (TRUE === $prod) {
            return 'https://mpsnare.iesnare.com/snare.js';
        } else {
            return 'https://ci-mpsnare.iovation.com/snare.js';
        }
    }

    public function convertAscii($string)
    {
        // Replace Single Curly Quotes
        $search[] = chr(226) . chr(128) . chr(152);
        $replace[] = "'";
        $search[] = chr(226) . chr(128) . chr(153);
        $replace[] = "'";

        // Replace Smart Double Curly Quotes
        $search[] = chr(226) . chr(128) . chr(156);
        $replace[] = '"';
        $search[] = chr(226) . chr(128) . chr(157);
        $replace[] = '"';

        // Replace En Dash
        $search[] = chr(226) . chr(128) . chr(147);
        $replace[] = '--';

        // Replace Em Dash
        $search[] = chr(226) . chr(128) . chr(148);
        $replace[] = '---';

        // Replace Bullet
        $search[] = chr(226) . chr(128) . chr(162);
        $replace[] = '*';

        // Replace Middle Dot
        $search[] = chr(194) . chr(183);
        $replace[] = '*';

        // Replace Ellipsis with three consecutive dots
        $search[] = chr(226) . chr(128) . chr(166);
        $replace[] = '...';

        // Apply Replacements
        $string = str_replace($search, $replace, $string);

        // Remove any non-ASCII Characters
        $string = preg_replace("/[^\x01-\x7F]/", "", $string);

        return $string;
    }

}
