<?php
// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Define Magento root directory
define('MAGENTO_ROOT', getcwd());

require MAGENTO_ROOT . '/app/Mage.php';

// Initialize Magento application
Mage::app('admin')->setUseSessionInUrl(false);

try {
    // Flush Magento cache
    Mage::app()->getCacheInstance()->flush();

    // Alternatively, you can clean all cache types
    Mage::app()->cleanCache();

    echo "Cache successfully flushed!\n";
} catch (Exception $e) {
    echo "Error flushing cache: " . $e->getMessage() . "\n";
}
