<?php

/**
 * Cacha la respuesta de Banwire-SPEI
 * @version 0.1.0
 * @author Ultiminio Ramos <contacto@ultiminioramos.com>
 * @update 2014-10-21
 */
/*
  echo '<pre>';
  ini_set('display_errors', '1');
 */
require '../../app/Mage.php';
Mage::App(); //might be "default"

if (!Mage::isInstalled()) {
    echo "Application is not installed yet, please complete install wizard first.";
    exit;
}

// Only for urls
// Don't remove this
$_SERVER['SCRIPT_NAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_NAME']);
$_SERVER['SCRIPT_FILENAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_FILENAME']);

#Mage::getModel('emailnewsletter/emailnewsletter')->getCurrentProducts();
require 'Mage/Core/Helper/Data.php';
//echo Mage::helper('mihelper')->fecha_legible_gmt_mx();
//echo "\n";

define('DIR_LOG', '/Payment/Banwire/');

$dir_log = Mage::getBaseDir('log') . DIR_LOG;
$scBitacoras = (int) Mage::getStoreConfig('payment/banwireSpei/bitacoras');

# cachar la respuesta en formato JSON
$response = json_decode(file_get_contents('php://input'), TRUE);

if (isset($response['reference'])) {

    try {
        $order = Mage::getModel('sales/order')
                ->load($response['order_id'], 'increment_id')
        ;

        $datosOrden = $order->getData();

        //$contenidoT = print_r($order->getData(), TRUE);

        if (0 == count($datosOrden)) {
            $contenido = print_r($response, TRUE); // . "\n\n" . $contenidoT;
            //date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'Banwire_SPEI_CatchNoEncontrados.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);

            die();
        }

        $payment = $order->getPayment($order);

        /**
         * change order status to 'Completed'
         */
        $tipo = 'deposit' == $response['type'] ? 'Parcialidad' : 'Pago Total';
        if (isset($response['tracking_code'])) {
            //$order->setState(Mage_Sales_Model_Order::STATE_COMPLETE, true)->save();
            $comment = '<b>El pago ya fue realizado por SPEI-Fast.</b>';
            $comment.= '<br/>';
            $comment.= '<b>Tipo:</b> ' . $tipo . '<br/>';
            $comment.= '<b>Orden:</b> ' . $response['order_id'] . '<br/>';
            $comment.= '<b>Referencia:</b> ' . $response['reference'] . '<br/>';
            $comment.= '<b>Clave de Rastreo:</b> ' . $response['tracking_code'] . '<br/>';
            if ('deposit' == $response['type']) {
                $comment.= '<b>Monto:</b> $' . number_format($response['amount'], 2, '.', ',') . '<br/>';
            }

            if ('complete' == $response['type']) {
                $status = Mage::getStoreConfig('payment/banwireSpei/order_status_once_paid');
                $order->addStatusHistoryComment($comment, $status);
            } else {
                $order->addStatusHistoryComment($comment, 'pending');
            }
            //$order->setData('state', $status);
            $order->save();

            #Autoinvoice
            if ('complete' == $response['type']) {
                invoicedOrder($order);
            }

            sendComprobante($order, $response);
        }

        if (1 == $scBitacoras) {
            $contenido = print_r($response, TRUE);
            //date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'Banwire_SPEI_Catch.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        /*
          echo 'Codigo de barras: ' . $payment_extra['response']['barcode'];
          echo '<br/>';
          echo '<img src="' . $url_ . '" title="' . $order->getIncrementId() . '" alt="' . $url_ . '" />';
          echo '<br/>';
          print_r($payment_extra);
         */
    } catch (Exception $e) {
        print_r($e->getMessage());
        $contenido = print_r($e->getMessage(), TRUE);
        //date_default_timezone_set('America/Mexico_City');
        file_put_contents($dir_log . 'Banwire_SPEI_IPN_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
    }

    //echo '<br/>';
    //print_r($payment->getAdditionalInformation());
} else {
    
}
if (1 == $scBitacoras) {
    //$contenido = print_r($response, TRUE);
    ////date_default_timezone_set('America/Mexico_City');
    //file_put_contents($dir_log . 'Banwire_SPEI_CatchTesting.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
}
/*
  echo '<br/>';
  print_r($_REQUEST);
  echo '</pre>';
 */

function sendComprobante(& $order, & $response)
{
    # preparación de datos
    $payment = $order->getPayment($order);
    $payment_extra = $payment->getAdditionalInformation();

    $mailSubject = 'Pago realizado por SPEI-Fast ' . $payment->getOrderId();

    $mediaFolder_ = 'banwire/spei/';

    /**
     * $sender can be of type string or array. You can set identity of
     * diffrent Store emails (like 'support', 'sales', etc.) found
     * in "System->Configuration->General->Store Email Addresses"
     */
    $senderName = Mage::getStoreConfig('trans_email/ident_sales/name');
    $senderEmail = Mage::getStoreConfig('trans_email/ident_sales/email');
    $salesEmailOrderCopyTo = Mage::getStoreConfig('sales_email/order/copy_to');

    /**
     * In case of multiple recipient use array here.
     */
    // Set recepient information
    //$recepientEmail = $order->getCustomerEmail();
    //$recepientName = $order->getCustomerName();
    // Get Store ID    
    $storeId = Mage::app()->getStore()->getId();

    // Set variables that can be used in email template
    
    if ('complete' == $response['type']) {
        $monto = '$' . number_format((double) $order->getGrandTotal(), 2, '.', ',');
        $leyenda = 'P A G A D O';
    } else {
        $monto = '$' . number_format($response['amount'], 2, '.', ',');
        $leyenda = 'P A R C I A L I D A D';
    }

    $vars = array(
        'reference' => $payment_extra['reference']
        , 'clabe' => $payment_extra['clabe']
        , 'spei_monto' => $monto
        , 'leyenda' => $leyenda
        , 'tipo_pago' => $tipo = 'deposit' == $response['type'] ? 'Parcialidad' : 'Pago Total'
        , 'tracking_code' => $response['tracking_code']
        , 'logo_banwspeifast' => Mage::getBaseUrl('media') . $mediaFolder_ . 'speifast.jpg'
        , 'incrementId' => $order->getIncrementId()
        , 'order' => $order
    );
    // Send Transactional Email
    $sender = array(
        'name' => $senderName,
        'email' => $senderEmail
    );
    $emailTpl = 'catch_response_banwireSpei_email_template';
    $destinatarios = explode(',', $salesEmailOrderCopyTo);
    foreach ($destinatarios as $recepientEmail) {
        Mage::getModel('core/email_template')
                ->loadDefault($emailTpl)
                ->setTemplateSubject($mailSubject)
                ->sendTransactional(0, $sender, $recepientEmail, '', $vars, $storeId)
        ;
    }

    #enviar al customer
    $billingAddress = $order->getBillingAddress();
    $customerEmail = $billingAddress->getEmail();
    $customerName = $billingAddress->getName();

    if (1 == $scBitacoras) {
        //date_default_timezone_set('America/Mexico_City');
        $dir_log = Mage::getBaseDir('log') . DIR_LOG;
        file_put_contents($dir_log . 'Banwire_SPEI_notify_IPN.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . '$customerEmail: ' . $customerEmail . "\n" . '$customerName: ' . $customerName . "\n\n", FILE_APPEND);
    }
    Mage::getModel('core/email_template')
            ->loadDefault($emailTpl)
            ->setTemplateSubject($mailSubject)
            ->sendTransactional($emailTpl, $sender, $customerEmail, $customerName, $vars, $storeId)
    ;
}

/**
 * crea la factura sin notificar al cliente
 * @param object $order
 * @param string $status
 */
function invoicedOrder(& $order)
{
    $autoInvoice = (int) Mage::getStoreConfig('payment/banwireSpei/autoinvoice');
    if (1 === $autoInvoice) {
        $invoice = $order->prepareInvoice();
        $invoice->setRequestedCaptureCase(Mage_Sales_Model_Order_Invoice::CAPTURE_OFFLINE);
        $invoice->register();

        $order->setCustomerNoteNotify(false);
        $status = Mage::getStoreConfig('payment/banwireSpei/order_status_once_paid');
        if ('processing' == $status) {
            $order->setIsInProcess(true);
        }

        $order->addStatusHistoryComment('Automatically INVOICED by Banwire.', false);
        prepareDownloadableItems($order);

        $transactionSave = Mage::getModel('core/resource_transaction');
        $transactionSave->addObject($invoice)->addObject($invoice->getOrder());
        $transactionSave->save();
    }
}

function prepareDownloadableItems(& $order)
{
    $orderItems = Mage::getModel('sales/order')->load($order->getId());

    foreach ($orderItems->getAllItems() as $itemId => $orderItem) {
        $product = Mage::getModel('catalog/product')->load($orderItem->getProductId());
        if ($product->getTypeId() == 'downloadable') {
            $product_links = Mage::getModel('downloadable/product_type')->getLinks($product);
            foreach ($product_links as $link) {
                $downloadPurchase = Mage::getModel('downloadable/link_purchased')
                        ->setOrderId($orderItem->getOrderId())
                        ->setOrderIncrementId($orderItems->getIncrementId())
                        ->setOrderItemId($orderItem->getId())
                        ->setCreatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setUpdatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setCustomerId($orderItems->getCustomerId())
                        ->setProductName($product->getName())
                        ->setProductSku($product->getSku())
                        ->setLinkSectionTitle('Click here to download');

                $downloadPurchase->save();

                $linkHash = strtr(base64_encode(microtime() . $downloadPurchase->getId() . $orderItem->getId() . $product->getId()), '+/=', '-_,');

                $downloadItem = Mage::getModel('downloadable/link_purchased_item')
                        ->setProductId($product->getId())
                        ->setNumberOfDownloadsBought(0)
                        ->setNumberOfDownloadsUsed(0)
                        ->setLinkTitle($link->getTitle())
                        ->setIsShareable($link->getData('is_shareable'))
                        ->setLinkFile($link->getData('link_file'))
                        ->setLinkType('file')
                        ->setStatus('available')
                        ->setCreatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setUpdatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setLinkHash($linkHash)
                        ->setOrderItemId($orderItem->getId())
                        ->setPurchasedId($downloadPurchase->getId());

                $downloadItem->save();
            }
        }
    }
}
