<?php
/**
 * =>>> Error (ko) <<<=
 *
 * Array
 * (
 *    [response] => ko
 *    [code] => 404
 *    [message] => El código ccv2 es invalido.
 * )
 *
 * Array
 * (
 *     [user] => desarrollo
 *     [id] => IUnBr4AlMQUa8sO
 *     [referencia] => 12345
 *     [date] => 11-04-2011 10:02:44
 *     [card] => 1234
 *     [response] => ko
 *     [code] => NA
 *     [message] => denied
 * )
 *
 * =>>> Success (ok) <<<=
 *
 * Array
 * (
 *     [user] => desarrollo
 *     [id] => 9nIzPEWS5RsGPqZ
 *     [referencia] => 12345
 *     [date] => 11-04-2011 10:06:40
 *     [card] => 3281
 *     [response] => ok
 *     [code_auth] => 538994
 *     [monto] => 0.5
 *     [client] => Roberto I Ramirez N
 * )
 *
 * =>>> Tarjetas de Prueba <<<=
 * 
 * Visa | MasterCard
 * 
 *   Para generar una transaccion ko cambiar el ccv2.
 *
 *  No. Tarjeta: 5204.1642.9999.9999
 *  Fecha Exp:
 *  ccv2: 999
 * 
 * American Express
 *
 *   Para generar un transaccion ko cambiar el ccv2 y para generar un erro de AVS cambiar la Calle o el C.P.
 * 
 *  No. Tarjeta: 3759.321345.99999
 *  Fecha Exp:
 *  ccv2: 9999
 *  Calle: Horacio
 *  C.P.: 11560
 */

define('DIR_UTIL', '');

require_once 'request.php';

class EnginePagoPro
{
  /**
   * URL del webservice
   *
   * @var string
   */
  private $_host = 'https://banwire.com/api.pago_pro';

  /**
   * Array contenedor de parametros para la API.
   *
   * @var array
   */
  private $_params = array(
    // Tipo de respuesta.
    'response_format' => 'HTTPQUERY',
    // Datos del usuario.
    'user' => NULL,
    // Datos del pago.
    'reference' => NULL,
    'currency' => 'MXN',
    'ammount' => NULL,
    'concept' => NULL,
    // Datos del cliente.
    'card_num' => NULL,
    'card_name' => NULL,
    'card_type' => NULL,
    'card_exp' => NULL,
    'card_ccv2' => NULL,
    'plan_type'=> NULL,
    'num_payments'=> NULL,
    'address' => NULL,
    'post_code' => NULL,
    'phone' => NULL,
    'mail' => NULL
  );

  /**
   * Contenedor de la respuesta, si procesas, de la API.
   *
   * @var string
   */
  private $_buffer = '';

  /**
   * Contenedor de la respuesta, procesada, de la API.
   *
   * @var array
   */
  private $_response = array();

  /**
   * Funcion constructora.
   *
   * @param string $host Dirección de la API.
   * @param string $path Ruta donde se almacenara la imagen del código de barras.
   */
  public function __construct($host = '')
  {
    if(!empty($host)) $this->_host = $host;
  }

   /**
   * Establece parametros de envío.
   *
   * @params string $key Nombre de la variable.
   * @params string $val Valor de la variable.
   */
  public function __set($key = '',$val = '')
  {
   if(empty($key) || empty($val)) return FALSE;
   if(!array_key_exists($key, $this->_params)) return FALSE;
   $this->_params[$key] = $val;
  }

  /**
   *   Funcion para acceder el valor de una variable, se
   * debe usar despues de enviar los datos usando send()
   * ya que depende de las variables de respuesta.
   *
   * @params string $key Nombre de la variable retornada
   * @return string
   */
  public function __get($key)
  {
    if(empty($this->_response)) return FALSE;
    if(!array_key_exists($key, $this->_response)) return FALSE;
    return $this->_response[$key];
  }

  public function send($params = array())
  {
    $postfields = empty($params) ? $this->_params : $params;
    $Request = new HTTP_Request($this->_host);
    $Request->setMethod('POST');
    foreach($postfields as $k => $v) $Request->addPostData($k, $v, TRUE);
    $response = $Request->sendRequest();
    $this->_buffer = $Request->getResponseBody();
    return $this->_parseResponse();
  }

   /**
   * Procesa la respuesta de la API.
   *
   * @param string $buffer Respuesta de la API.
   */
  private function _parseResponse($buffer = '')
  {
   if(empty($buffer)) $buffer = $this->_buffer;
   if(empty($buffer)) return FALSE;
   switch(strtoupper($this->_params['response_format']))
   {
     case 'JSON':
       $this->_response = json_decode($buffer, TRUE);
     break;
     case 'HTTPQUERY':
     case 'HTTP_QUERY':
       parse_str($buffer, $this->_response);
     break;
     case 'XML':
     break;
     case 'ARRAY':
     break;
   }
   return $this->validateTransaction();
  }

   /**
   * Valida que la transaccion haya sido exitosa.
   *
   * @return boolean.
   */
  public function validateTransaction()
  {
   if(empty($this->_response)) return FALSE;
   return $this->_response['response'] === 'ok';
  }

  /**
   * Obtiene la respuesta procesada de la API.
   *
   * @return array
   */
  public function getResponse()
  {
   return $this->_response;
  }

  public function getError()
  {
   return $this->_response['response'] === 'ko' ? "[{$this->_response['code']}] - {$this->_response['message']}" : FALSE;
  }
}