<?php

/**
 * Cacha la respuesta de oxxo
 * @version 0.1.0
 * @author Ultiminio Ramos <contacto@ultiminioramos.com>
 * @update 2014-10-21
 */
/*
  echo '<pre>';
  ini_set('display_errors', '1');
 */
require '../../app/Mage.php';
Mage::App(); //might be "default"

if (!Mage::isInstalled()) {
    echo "Application is not installed yet, please complete install wizard first.";
    exit;
}

// Only for urls
// Don't remove this
$_SERVER['SCRIPT_NAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_NAME']);
$_SERVER['SCRIPT_FILENAME'] = str_replace(basename(__FILE__), 'index.php', $_SERVER['SCRIPT_FILENAME']);

#Mage::getModel('emailnewsletter/emailnewsletter')->getCurrentProducts();
require 'Mage/Core/Helper/Data.php';
//echo Mage::helper('mihelper')->fecha_legible_gmt_mx();
//echo "\n";

define('DIR_LOG', '/Payment/Banwire/');

$dir_log = Mage::getBaseDir('log') . DIR_LOG;
$scBitacoras = (int) Mage::getStoreConfig('payment/banwireOxxo/bitacoras');

if (isset($_REQUEST['referencia'])) {

    try {

        $orderCodigob = $_REQUEST['cb'];
        $order = Mage::getModel('sales/order')
                //->load($orderCodigob, 'oxxo_cb')
                ->load($_REQUEST['referencia'], 'increment_id')
        ;

        $datosOrden = $order->getData();

        //$contenidoT = print_r($order->getData(), TRUE);

        if (0 == count($datosOrden)) {
            $contenido = print_r($_REQUEST, TRUE); // . "\n\n" . $contenidoT;
            //date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'BanwireOxxo_CatchNoEncontrados.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);

            die();
        }

        $payment = $order->getPayment($order);

        /**
         * change order status to 'Completed'
         */
        if (1 == (int) $_REQUEST['flag']) {
            //$order->setState(Mage_Sales_Model_Order::STATE_COMPLETE, true)->save();
            $comment = '<b>El pago ya fue realizado en una tienda OXXO.</b>';
            $comment.= '<br/>';
            $comment.= '<b>Plaza:</b> ' . $_REQUEST['plaza'] . '<br/>';
            $comment.= '<b>Tienda:</b> ' . $_REQUEST['tienda'] . '<br/>';
            $fecha_pago = substr($_REQUEST['fecha'], 0, 4) . '-' . substr($_REQUEST['fecha'], 4, 2) . '-' . substr($_REQUEST['fecha'], -2, 2);
            $comment.= '<b>Fecha:</b> ' . $fecha_pago . ', ' . $_REQUEST['hora'] . '<br/>';
            $comment.= '<b>Código B:</b> ' . $_REQUEST['cb'] . '<br/>';
            $comment.= '<b>Referencia:</b> Order #' . $_REQUEST['referencia'] . '<br/>';
            $comment.= '<b>Monto:</b> $' . $_REQUEST['monto'] . '<br/>';
            $comment.= '<b>Referencia ext:</b> ' . $_REQUEST['referencia_ext'] . '<br/>';
            $comment.= '<b>Flag:</b> ' . $_REQUEST['flag'];

            $status = Mage::getStoreConfig('payment/banwireOxxo/order_status_once_paid');

            $order->addStatusHistoryComment($comment, $status);
            //$order->setData('state', $status);
            $order->save();

            #Autoinvoice
            invoicedOrder($order);

            sendComprobante($order);
        }

        # solamente despliego datos para modo de testing, comentar en producción
        $payment_extra = $payment->getAdditionalInformation();
        $ultimo = end($payment_extra);
        $key = key($payment_extra);

        $mediaFolder_ = 'banwire/oxxo_PXF5918/';
        $url_ = Mage::getBaseUrl('media') . '/' . $mediaFolder_ . $order->getIncrementId() . '_' . $payment_extra['response']['barcode'] . '.png';

        if (1 == $scBitacoras) {
            $contenido = print_r($_REQUEST, TRUE);
            //date_default_timezone_set('America/Mexico_City');
            file_put_contents($dir_log . 'BanwireOxxo_Catch.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
        }

        /*
          echo 'Codigo de barras: ' . $payment_extra['response']['barcode'];
          echo '<br/>';
          echo '<img src="' . $url_ . '" title="' . $order->getIncrementId() . '" alt="' . $url_ . '" />';
          echo '<br/>';
          print_r($payment_extra);
         */
    } catch (Exception $e) {
        print_r($e->getMessage());
        echo '</pre>';
        $contenido = print_r($e->getMessage(), TRUE);
        //date_default_timezone_set('America/Mexico_City');
        file_put_contents($dir_log . 'BanwireOxxo_Error.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
    }

    //echo '<br/>';
    //print_r($payment->getAdditionalInformation());
} else {
    
}
if (1 == $scBitacoras) {
    $contenido = print_r($_REQUEST, TRUE);
    //date_default_timezone_set('America/Mexico_City');
    //file_put_contents($dir_log . 'BanwireOxxo_CatchTesting.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . $contenido . "\n\n", FILE_APPEND);
}
/*
  echo '<br/>';
  print_r($_REQUEST);
  echo '</pre>';
 */

function sendComprobante(& $order)
{
    # preparación de datos
    $payment = $order->getPayment($order);
    $payment_extra = $payment->getAdditionalInformation();

    $mediaFolder_ = 'banwire/oxxo_PXF5918/';
    $url_ = Mage::getBaseUrl('media') . '/' . $mediaFolder_ . $order->getIncrementId() . '_' . $payment_extra['response']['barcode'] . '.png';

    $mailSubject = 'Pago realizado en Oxxo ' . $payment->getOrderId();

    /**
     * $sender can be of type string or array. You can set identity of
     * diffrent Store emails (like 'support', 'sales', etc.) found
     * in "System->Configuration->General->Store Email Addresses"
     */
    $senderName = Mage::getStoreConfig('trans_email/ident_sales/name');
    $senderEmail = Mage::getStoreConfig('trans_email/ident_sales/email');
    $salesEmailOrderCopyTo = Mage::getStoreConfig('sales_email/order/copy_to');

    /**
     * In case of multiple recipient use array here.
     */
    // Set recepient information
    //$recepientEmail = $order->getCustomerEmail();
    //$recepientName = $order->getCustomerName();
    // Get Store ID    
    $storeId = Mage::app()->getStore()->getId();

    // Set variables that can be used in email template

    $vars = array(
        'oxxo_id' => substr($payment_extra['response']['barcode'], 2, 8)
        , 'oxxo_cb' => $payment_extra['response']['barcode']
        , 'oxxo_monto' => '$' . number_format((double) $order->getGrandTotal(), 2, '.', ',')
        , 'oxxo_fecha_vigencia' => $payment_extra['response']['fecha_vigencia']
        , 'oxxo_path_img' => $url_
        , 'logo_banwoxxo' => Mage::getBaseUrl('media') . $mediaFolder_ . 'banwire-oxxo.png'
        , 'incrementId' => $order->getIncrementId()
        , 'order' => $order
    );

    // Send Transactional Email
    $sender = array(
        'name' => $senderName,
        'email' => $senderEmail
    );
    $emailTpl = 'catch_response_banwireOxxo_email_template';
    $destinatarios = explode(',', $salesEmailOrderCopyTo);
    foreach ($destinatarios as $recepientEmail) {
        Mage::getModel('core/email_template')
                ->loadDefault($emailTpl)
                ->setTemplateSubject($mailSubject)
                ->sendTransactional(0, $sender, $recepientEmail, '', $vars, $storeId)
        ;
    }

    #enviar al customer
    $billingAddress = $order->getBillingAddress();
    $customerEmail = $billingAddress->getEmail();
    $customerName = $billingAddress->getName();

    if (1 == $scBitacoras) {
        //date_default_timezone_set('America/Mexico_City');
        $dir_log = Mage::getBaseDir('log') . DIR_LOG;
        file_put_contents($dir_log . 'Banwire_OXXO_notify_IPN.log', "=======" . date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())) . "\n" . '$customerEmail: ' . $customerEmail . "\n" . '$customerName: ' . $customerName . "\n\n", FILE_APPEND);
    }
    Mage::getModel('core/email_template')
            ->loadDefault($emailTpl)
            ->setTemplateSubject($mailSubject)
            ->sendTransactional($emailTpl, $sender, $customerEmail, $customerName, $vars, $storeId)
    ;
}

/**
 * crea la factura sin notificar al cliente
 * @param object $order
 * @param string $status
 */
function invoicedOrder(& $order)
{
    $autoInvoice = (int) Mage::getStoreConfig('payment/banwireOxxo/autoinvoice');
    if (1 === $autoInvoice) {
        $invoice = $order->prepareInvoice();
        $invoice->setRequestedCaptureCase(Mage_Sales_Model_Order_Invoice::CAPTURE_OFFLINE);
        $invoice->register();

        $order->setCustomerNoteNotify(false);
        $status = Mage::getStoreConfig('payment/banwireOxxo/order_status_once_paid');
        if ('processing' == $status) {
            $order->setIsInProcess(true);
        }

        $order->addStatusHistoryComment('Automatically INVOICED by Banwire.', false);
        prepareDownloadableItems($order);

        $transactionSave = Mage::getModel('core/resource_transaction');
        $transactionSave->addObject($invoice)->addObject($invoice->getOrder());
        $transactionSave->save();
    }
}

function prepareDownloadableItems(& $order)
{
    $orderItems = Mage::getModel('sales/order')->load($order->getId());

    foreach ($orderItems->getAllItems() as $itemId => $orderItem) {
        $product = Mage::getModel('catalog/product')->load($orderItem->getProductId());
        if ($product->getTypeId() == 'downloadable') {
            $product_links = Mage::getModel('downloadable/product_type')->getLinks($product);
            foreach ($product_links as $link) {
                $downloadPurchase = Mage::getModel('downloadable/link_purchased')
                        ->setOrderId($orderItem->getOrderId())
                        ->setOrderIncrementId($orderItems->getIncrementId())
                        ->setOrderItemId($orderItem->getId())
                        ->setCreatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setUpdatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setCustomerId($orderItems->getCustomerId())
                        ->setProductName($product->getName())
                        ->setProductSku($product->getSku())
                        ->setLinkSectionTitle('Click here to download');

                $downloadPurchase->save();

                $linkHash = strtr(base64_encode(microtime() . $downloadPurchase->getId() . $orderItem->getId() . $product->getId()), '+/=', '-_,');

                $downloadItem = Mage::getModel('downloadable/link_purchased_item')
                        ->setProductId($product->getId())
                        ->setNumberOfDownloadsBought(0)
                        ->setNumberOfDownloadsUsed(0)
                        ->setLinkTitle($link->getTitle())
                        ->setIsShareable($link->getData('is_shareable'))
                        ->setLinkFile($link->getData('link_file'))
                        ->setLinkType('file')
                        ->setStatus('available')
                        ->setCreatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setUpdatedAt(date('Y-m-d H:i:s', Mage::getModel('core/date')->timestamp(time())))
                        ->setLinkHash($linkHash)
                        ->setOrderItemId($orderItem->getId())
                        ->setPurchasedId($downloadPurchase->getId());

                $downloadItem->save();
            }
        }
    }
}
