<?php
/**
 * SharkGate - SharkActiveDefence
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 *
 * @category    SharkGate
 * @package     SharkGate_SharkActiveDefence
 * @author      Nikola Jocic
 * @copyright   Copyright (c) 2017 SharkGate LTD (http://www.sharkgate.net)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

error_reporting(E_ALL);

ini_set ('memory_limit', '1024M');    
ini_set ('max_execution_time', '600');  
ini_set ('display_errors', 'On');  

define ("MONITOR_ROOT", getcwd());

if (version_compare(PHP_VERSION, '5.4.0', '<')) {
    include 'inc/class.RecursiveCallbackFilterIterator.php';
}

include 'inc/class.FileMonitor.php';
include 'inc/class.MailGun.php';

$FileMonitor = new FileMonitor;

if (isset($_GET['scan']) && $_GET['scan'] == "sharkgate-scan") {  
    $FileMonitor->scan(); 
} else {
    header('HTTP/1.0 403 Forbidden');
}

if (isset($_GET['delete']) && $_GET['delete'] == "true") {
    $FileMonitor->autoDestruct(MONITOR_ROOT);	
}